Shader "Mario Galaxy"
{
    Properties
    {
        _Color ("Color", Color) = (1, 1, 1, 1)
        _MainTex ("Albedo (RGB)", 2D) = "white" {}
        _Glossiness ("Smoothness", Range(0, 1)) = 0.5
        _Metallic ("Metallic", Range(0, 1)) = 0
        _BloomIntensity ("Bloom Intensity", Range(0, 1)) = 0.5
        _BloomThreshold ("Bloom Threshold", Range(0, 1)) = 0.5
        _RimPower ("Rim Power", Range(0, 10)) = 5
        _RimColor ("Rim Color", Color) = (1, 1, 1, 1)
        _RimGlow ("Rim Glow", Range(0, 1)) = 0.1
        _UseCameraDirection ("Use Camera Direction", Range(0, 1)) = 0
        _RimWidth ("Rim Width", Range(0, 1)) = 0.1
    }

    SubShader
    {
        Tags { "RenderType" = "Opaque" }
        LOD 200

        CGPROGRAM
        #pragma surface surf Standard fullforwardshadows

        // Activation des ombres de type cascade
        #pragma multi_compile _ _MAIN_LIGHT_SHADOWS _MAIN_LIGHT_SHADOWS_CASCADE
        #pragma multi_compile _ _SHADOWS_SOFT

        sampler2D _MainTex;

        struct Input
        {
            float2 uv_MainTex;
            float3 WorldPos;
            float3 WorldRefl;
            INTERNAL_DATA
        };

        half _Glossiness;
        half _Metallic;
        fixed4 _Color;

        fixed _BloomIntensity;
        fixed _BloomThreshold;

        fixed _RimPower;
        fixed4 _RimColor;
        fixed _RimGlow;
        fixed _UseCameraDirection;
        fixed _RimWidth;

        // Lighting function
        fixed3 LightingMarioGalaxy(SurfaceOutputStandard s, fixed3 viewDir, fixed3 normal)
        {
            fixed3 rimLighting = _LightColor0.rgb * _RimColor.rgb * (1 - saturate(dot(_WorldSpaceLightPos0, normal)));
            return rimLighting;
        }

        // Surface shader function
        void surf(Input IN, inout SurfaceOutputStandard o)
        {
            // Albedo comes from a texture tinted by color
            fixed4 c = tex2D(_MainTex, IN.uv_MainTex) * _Color;

            // Metallic and smoothness come from slider variables
            o.Metallic = _Metallic;
            o.Smoothness = _Glossiness;

            // Albedo
            o.Albedo = c.rgb;

            // Alpha
            o.Alpha = c.a;

            // Bloom effect:
            // Apply bloom based on intensity and threshold
            fixed4 bloom = fixed4(0, 0, 0, 0);
            if (max(c.r, max(c.g, c.b)) > _BloomThreshold)
            {
                bloom += c * _BloomIntensity;
            }

            // Emissive
            o.Emission = bloom * LinearToGammaSpace(o.Albedo) * _Color;

            // Rim lighting
            fixed3 viewDir = normalize(_WorldSpaceCameraPos - IN.WorldPos);
            fixed3 reflection = normalize(viewDir - 2 * dot(viewDir, o.Normal) * o.Normal);

            // Utiliser la direction en fonction de la propriété _UseCameraDirection
            fixed rim;
            if (_UseCameraDirection > 0)
            {
                rim = saturate(dot(viewDir, reflection));
            }
            else
            {
                rim = saturate(dot(_WorldSpaceLightPos0.xyz, reflection));
            }

            // Modulation de la contribution du rim par la largeur
            rim = smoothstep(1.0 - _RimWidth, 1.0, rim);

            // Exponential blending for rim color
            fixed rimBlend = 1.0 - exp(-_RimPower * rim);

            // Apply slight glow to rim color
            fixed3 rimColorWithGlow = lerp(float3(0, 0, 0), _RimColor.rgb, rimBlend) * (1 + _RimGlow);

            o.Emission += rimColorWithGlow;
        }
        ENDCG
    }

    Fallback "Diffuse"
}
